;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: DelSig_1.inc
;;   Version: 1.1, Updated on 2004/11/17 at 09:47:57
;;
;;  DESCRIPTION: Assembler declarations for the Delta-Sigma A/D Converter
;;               with a 2nd-order modulator and based on a type 2 decimator.
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2004. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"

;--------------------------------------------------
; Constants for DelSig_1 API's.
;--------------------------------------------------

DelSig_1_INT_REG:                  equ  0e1h
DelSig_1_INT_MASK:                 equ  80h     ; Interrupt mask

DelSig_1_OFF:                      equ  0
DelSig_1_LOWPOWER:                 equ  1
DelSig_1_MEDPOWER:                 equ  2
DelSig_1_HIGHPOWER:                equ  3

DelSig_1_DATA_READY_BIT:           equ  10h
DelSig_1_2S_COMPLEMENT:            equ  0

;--------------------------------------------------
; Register Address Constants for DelSig_1
;--------------------------------------------------

DelSig_1_PWM_DR0_MSB:              equ 0x3c    ; Period reg
DelSig_1_PWM_DR0_LSB:              equ 0x38    ; Period reg
DelSig_1_PWM_DR1_MSB:              equ 0x3d    ; Down count reg
DelSig_1_PWM_DR1_LSB:              equ 0x39    ; Down count reg
DelSig_1_PWM_DR2_MSB:              equ 0x3e    ; Compare reg
DelSig_1_PWM_DR2_LSB:              equ 0x3a    ; Compare reg
DelSig_1_PWM_CR0_MSB:              equ 0x3f    ; Control reg
DelSig_1_PWM_CR0_LSB:              equ 0x3b    ; Control reg
DelSig_1_PWM_FN_MSB:               equ 0x3c    ; Function reg
DelSig_1_PWM_FN_LSB:               equ 0x38    ; Function reg
DelSig_1_PWM_SL_MSB:               equ 0x3d    ; Input  select reg
DelSig_1_PWM_SL_LSB:               equ 0x39    ; Input  select reg
DelSig_1_PWM_OS_MSB:               equ 0x3e    ; Output select reg
DelSig_1_PWM_OS_LSB:               equ 0x3a    ; Output select reg

DelSig_1_AtoD1cr0:                 equ 0x94    ; SC Block 1 Control Reg 0
DelSig_1_AtoD1cr1:                 equ 0x95    ; SC Block 1 Control Reg 1
DelSig_1_AtoD1cr2:                 equ 0x96    ; SC Block 1 Control Reg 2
DelSig_1_AtoD1cr3:                 equ 0x97    ; SC Block 1 Control Reg 3
DelSig_1_AtoD2cr0:                 equ 0x84    ; SC Block 2 Control Reg 0
DelSig_1_AtoD2cr1:                 equ 0x85    ; SC Block 2 Control Reg 1
DelSig_1_AtoD2cr2:                 equ 0x86    ; SC Block 2 Control Reg 2
DelSig_1_AtoD2cr3:                 equ 0x87    ; SC Block 2 Control Reg 3


; end of file DelSig_1.inc
